/*-----------------------------------------------------------------------------------------------------------------------------
FileName: particleDetector.h 
Autors: Mathieu Gisselbrecht
Date : Creation -  Septembre 2006
-----------------------------------------------------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------------------------------------------------------
// MISC #DEFINEs
//-----------------------------------------------------------------------------------------------------------------------------
#define MAX_DETECTOR			2
#define NB_CANAUX_TEMPORELS		500000 //13000	
#define IMAGE_BIN				66 
#define MAXCOINCIDENCEORDER 	5

// -------------- Specific for  acquisition --------------
#define END_OF_ACQUISITION	0
#define ON_ACQUISITION  	1
#define CREATE				2
#define ADD					3			
#define INCREASE_SIZE 		4
#define CHECK_IT_EXISTS 	5


// -------------- Specific for IGOR --------------
#define PATHVAR 		"root:var:"
#define PATHDET			"root:var:detector"

//-----------------------------------------------------------------------------------------------------------------------------
// TYPEDEF AND STRUCTURE : DETECTOR
//-----------------------------------------------------------------------------------------------------------------------------
typedef struct  SDetector{
	char  			name[50], suffix[8];
	long 			num;
	long 			type;							// Detector type bit1: time, bit2-3: X-Y, bit4: pixel-line...
	void 			*device; 

	// -------------- Generic Part --------------
	long 			minOrder, maxOrder;							// Minimum and maximum of the coincidence order (single, double...)
	long 			tof[NB_CANAUX_TEMPORELS];					// Time Of Flight
	long			tof_window, tof_offset, tof_bin; 			// tof_window (micro s), tof_offset (ns) , bining (ps);
	long 			image[IMAGE_BIN*IMAGE_BIN], projX[IMAGE_BIN], projY[IMAGE_BIN], image_bin;	// Raw Detector Image
	long 			stat[MAXCOINCIDENCEORDER];					// statistic on single, double, triple...
	DOUBLE 			efficiency; 								// Localization efficiency (%)
	
	// -------------- Event control --------------
	long			nTimeGroups;			
	float	 		MeanTimeofGroup[MAXCOINCIDENCEORDER+1], xMoyen[MAXCOINCIDENCEORDER+1], yMoyen[MAXCOINCIDENCEORDER+1];
	
	// -------------- Igor Stack --------------
	long 			PtrIndexStack,EndIndexStack;		// References to the index of the data base (pointer, nb events -> w_p, w_n)
	long 			PtrDataStack, EndDataStack;			// References to the data base (time, x, y -> w_t, w_x, w_y)
	waveHndl		w_p, w_n, w_x, w_y, w_t;			// wavehandle containing the data bases for Igor
	long 			hState[5];							// state of igor waves lock/unlock	
} TDetector;


//-----------------------------------------------------------------------------------------------------------------------------
// TYPEDEF AND STRUCTURE : LIST OF DETECTOR
//-----------------------------------------------------------------------------------------------------------------------------
typedef struct  SListDetector{
	long 		modeDetector; 
	long 		nbDetector;							// total amount of detector
	long 		wordsizeEvent;						// buffer size for event
	long		maskTime, maskDetector, maskChannel, timeBased; 
	long 		sigbitTime, sigbitDetector, sigbitChannel; 
	TDetector	Detector[MAX_DETECTOR];		// reference on each detector structure
} TListDetector;

//-----------------------------------------------------------------------------------------------------------------------------
// PROTOTYPES : DETECTORS
//-----------------------------------------------------------------------------------------------------------------------------

void newEvent(TDetector *Detector);
short addEvent(TDetector *Detector, long tdcTime, long tdcChannel);
short correctEvent(TListDetector *ListOfDetector);
short analyzeEvent(TListDetector *ListOfDetector);

//-----------------------------------------------------------------------------------------------------------------------------
// PROTOTYPES : IGOR INTERFACE  (DETECTOR LIST, DETECTOR)
//-----------------------------------------------------------------------------------------------------------------------------
short updateDetector(TDetector *Detector, int mode);
short createDetector(TDetector *Detector, int num, char *name, int type, 
			int minOrder, int maxOrder, long tof_window, long tof_offset, long tof_bin, long image_bin);
short getigorDetector(TDetector *Detector,int num);

short createDetectorList(TListDetector *ListOfDetector, int mode);
short setigorDetectorList(TListDetector *ListOfDetector);
short getigorDetectorList(TListDetector *ListOfDetector);